#pragma rtGlobals=1		// Use modern global access method.

Menu "Plot&Fit"

	Submenu "Miscellaneous"
		"OVAL density",DWS_DensityPnl()
	End
	
End

Function DWS_DensityPnl()
	IN2G_CheckScreenSize("height",670)
	DoWindow DWS_DensityPnl
	if(V_Flag)
		DoWindow/K DWS_DensityPnl
	endif
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:DensityTool"))

		Newdatafolder root:Packages:DensityTool
	endif
	setdatafolder Root:packages:Densitytool
	variable/g root:Packages:DensityTool:Smoothing= 0.4, root:Packages:DensityTool:GraphLogY=0
	variable/g root:Packages:DensityTool:GraphLogX=0,root:Packages:DensityTool:DisplayOutput=0
	variable/g root:Packages:DensityTool:NewGraph=1,root:Packages:DensityTool:GraphErrors=0
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	PlotDensData("yavedata","xavedata", "")
	setAxis bottom 0, 1
	SetAxis/A left
	Removefromgraph yavedata
	//removefromgraph yavedata
	textBox/K/N=text0
	killwaves xavedata,yavedata
end



Function PlotDensData(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K DensGraph
	Display/K=1/N=DensGraph/W=(1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),35*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 200
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="Density Tool",Labelback=0, POS={200,5},Size={200,20}
	Button GenerateErrors,pos={200,110},size={100,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="Generate Error Wave"	
variable YPOS=130, XPOS=2
	Button PlotDensData,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="PlotDATA"	
	Button Format,pos={60,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="Color"				
  	Button RemoveDensTrace,pos={140,YPOS},size={80,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="RemoveTrace"	
	CheckBox GraphLogY pos={325,YPOS},title="Log Y?", variable= root:Packages:DensityTool:GraphLogY, proc=DWS_GenPlotCheckBox
	CheckBox GraphLogX pos={325,YPOS-15},title="Log X?", variable= root:Packages:DensityTool:GraphLogX, proc=DWS_GenPlotCheckBox
	CheckBox GraphErrors pos={325,YPOS-30},title="Error bars?", variable=root:Packages:DensityTool:GraphErrors
	CheckBox GraphErrors proc=DWS_DensityCheckBox	
YPOS=170
	Button Smooth,pos={0,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="Smooth"			
	SetVariable Smoothing, pos={50,YPOS}, size={100,20},title="smoothing"
	SetVariable Smoothing, limits={0,1,0.05},value= root:Packages:DensityTool:Smoothing
	Button Diff,pos={155,YPOS},size={80,16},font="Times New Roman",fSize=10,proc=DWS_DensButtonProc,title="Differentiate"
	CheckBox DisplayOutput pos={240,YPOS},title="Display?", variable= root:Packages:DensityTool:DisplayOutput//probs*****************
	
	CheckBox NewGraph pos={300,YPOS},title="New Graph?", variable= root:Packages:DensityTool:NewGraph
	
	setdatafolder root:Packages:DensityTool
	String PckgDataFolder="DensityTool"
	String PanelWindowName="DensGraph"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes="SLDPROFILE;"//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"SLDPROFILE*;"//"*_par;" or "r*;"	
	String UserNameString="Profile"//"_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0
	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	YPOS=2
	String Checkboxes=ControlNameList("", ";" ,"Use*")
	IF(-1!=strsearch(checkboxes, "UseQRSData",0,2))
		CheckBox UseQRSData pos={XPOS,YPOS}
	Elseif(-1!=strsearch(checkboxes, "UseIndra2Data",0,2))
		CheckBox UseIndra2Data pos={XPOS,YPOS+13}
	Elseif(-1!=strsearch(checkboxes, "UseResults",0,2))
		CheckBox UseResults pos={XPOS+100,YPOS}
	elseif (-1!=strsearch(checkboxes, "UseUserDefinedData",0,2))
		CheckBox UseUserDefinedData pos={XPOS+100,YPOS+13}
	endif
	YPOS=YPOS+5
	PopupMenu SelectDataFolde pos={XPOS,YPOS+23}
	PopupMenu IntensityDataName pos={XPOS,YPOS+73}
	PopupMenu QvecDataName pos={XPOS,YPOS+48}
	PopupMenu ErrorDataName pos={XPOS,YPOS+98}	
	PopupMenu QvecDataName title="X Wave"
	PopupMenu IntensityDataName title="Y Wave"
	PopupMenu ErrorDataName title="S Wave"
	PopupMenu SelectDataFolder title="Folder"
	CheckBox UseResults, pos={70, 0},value=0  
	//CheckBox UseQRSData ,value=1,pos={0, 0},value=0  
end

Function DWS_DensButtonProc(ctrlName) : ButtonControl
	String ctrlName		
	SVAR FolderName=root:Packages:DensityTool:DataFolderName
	SVAR RWaveName=root:Packages:DensityTool:IntensityWaveName
	SVAR QWaveName=root:Packages:DensityTool:QWavename	
	SVAR SWaveName=root:Packages:DensityTool:ErrorWavename		
	NVAR GraphLogY=root:Packages:DensityTool:GraphLogY
	NVAR GraphLogX=root:Packages:DensityTool:GraphLogX
	NVAR Smoothing=root:Packages:DensityTool:Smoothing
	NVAR Newgraph= root:Packages:DensityTool:NewGraph
	NVAR DisplayOutput=root:Packages:DensityTool:DisplayOutput
	
	NVAR NewGraph= root:Packages:DensityTool:NewGraph
	NVAR smoothing=root:Packages:DensityTool:Smoothing
	string newwavename, tracename, text,name
	
	if (datafolderexists(foldername))
		setdatafolder foldername
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
		wave SWave=$Swavename			
	endif
	
	IF(cmpstr(ctrlName,"GenerateErrors")==0)
		swavename="s"+rwavename[0,29]
		duplicate/o rwave, $swavename
	IN2G_GenerateSASErrors(rwave,$swavename,2,1, 0,0,0)//(IntWave,ErrWave,Pts_avg,Pts_avg_multiplier, IntMultiplier,MultiplySqrt)	
	endif
	
	if (cmpstr(ctrlName,"Format")==0)
		//ChangetoLineandPoints(3,1)
	endif
	
	IF(cmpstr(ctrlName,"PlotDensData")==0)	
		setdatafolder  FolderName
		Appendtograph/W=DensGraph RWave vs qwave
		Legend/C/N=text1
		Label bottom "\\Z14\\f01\\F'Times New Roman'Concentration"
	 	setaxis/A
			//SetAxis bottom 0.01,.15
			ModifyGraph log(left)=graphlogy	
			ModifyGraph log(bottom)=graphlogX	
		
			ModifyGraph mode=3,tick=2,mirror=1,axThick=2
			Label Left "\Z14\f01\F'arial'Density (g/cm\S3\M\Z14)"
			Label bottom "\\Z14\\f01\\F'Times New Roman'Percent"
			TextBox/K/N=FolderLegend
			SetAxis bottom 0,100
		endif
		
		IF(cmpstr(ctrlName,"RemovedensTrace")==0)
			string tracelist=TraceNameList("DensGraph", ";", 1 )
		 	tracename=StringFromList(0, tracelist,";")
			If (!stringmatch(tracename, "" ))
				tracename=StringFromList(1, tracelist,";")
				RemoveFromGraph $tracename	
			else
			endif
		endif
		
	IF(cmpstr(ctrlName,"Smooth")==0)
		newwavename=rwavename+"_smp"	+num2str(smoothing)[2,100]
		Duplicate/O $rwavename,$newwavename;DelayUpdate
		Loess/V=2/SMTH=(smoothing) factors={$qwavename}, srcWave= $newwavename;DelayUpdate
		Note  $newwavename , "Loess_smoothing="+num2str(smoothing)+";xwave="+qwavename+";"
		IF (Displayoutput)
			IF (Newgraph)
				Display/K=1 $newwavename vs $qwavename
			else
				Appendtograph $newwavename vs $qwavename
			endif
			ModifyGraph rgb($newwavename)=(0,0,0)
		endif
	endif
	
	IF(cmpstr(ctrlName,"diff")==0)
		newwavename=rwavename+"_diff"	
		Duplicate/O $rwavename,$newwavename;DelayUpdate
		Differentiate $rwavename/X=$qwavename/D=$newwavename;DelayUpdate
		text=note($rwavename)
		text=stringbykey("Loess_smoothing", text ,"=") 
		name="tg"+text[2,100]
		text="smooth="+text
		
		IF (Displayoutput)
			IF (Newgraph)
				Display/K=1/N=Differential $newwavename vs $qwavename
				ModifyGraph rgb($newwavename)=(0,1000,0)
				Legend/C/N=text0/A=MC
				Tag/C/N=$name $newwavename, 20,text
				Label left "\\Z16Derivative";DelayUpdate
				Label bottom "\\Z16Percent"
				ModifyGraph tick=2,mirror=1,axThick=2, fStyle=1,fSize=16,width=300,height=300;DelayUpdate
				SetAxis bottom 0,100

			else
				dowindow Differential
				if(v_flag==1)
					Appendtograph/W=Differential $newwavename vs $qwavename
					ModifyGraph/W=Differential rgb($newwavename)=(0,0,10000)
					Tag/W=Differential/C/N=$name $newwavename, 20,text
				else
					Doalert 0, "Graph does not exist"
				endif
			endif		
		endif
	Endif
		
	end
	
Function DWS_DensityCheckBox(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	SVAR FolderName=root:Packages:DensityTool:DataFolderName
	SVAR RWaveName=root:Packages:DensityTool:IntensityWaveName
	SVAR QWaveName=root:Packages:DensityTool:QWavename	
	SVAR SWaveName=root:Packages:DensityTool:ErrorWavename	
	
	//NVAR DisplayOutput=root:Packages:DensityTool: DisplayOutput
	//NVAR NewGraph= root:Packages:DensityTool: NewGraph
	setdatafolder foldername	
	ErrorBars $rwavename OFF 
	if (cmpstr("Grapherrors",ctrlName)==0)		
		if(checked)
			ErrorBars $rwavename Y,wave=($swavename,$swavename)
		endif
	endif

end